<?php

namespace Elementor;

use Qoxag\Core\Elementor\Controls\Qoxag_Layout;
use Qoxag\Core\Elementor\Controls\Qoxag_Post_Query;

if (!defined('ABSPATH')) exit;


class Qoxag_Post_Loadmore extends Widget_Base
{
    use \Qoxag\Core\Elementor\Traits\Grid_Controls;

    public $base;

    public function get_name()
    {
        return 'post-loadmore';
    }

    public function get_title()
    {

        return esc_html__('Qoxag Post Load More', 'qoxag');

    }

    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }

    public function get_categories()
    {
        return ['qoxag-elements'];
    }

    protected function register_controls()
    {

        /*
         * Post Grid Settings
         */
        $this->start_controls_section(
            'postgrid_section',
            [
                'label' => esc_html__('Post Loadmore Settings', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Qoxag_Post_Query::get_type(),
            [
                'name' => 'query',
                'exclude' => ['posts_per_page_slider_note', 'slides_to_show', 'post_tabs']
            ]
        );

        $this->add_control(
            'show_loadmore',
            [
                'label' => esc_html__('Show Load More', 'qoxag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'qoxag'),
                'label_off' => esc_html__('No', 'qoxag'),
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        /*
         * Layout Settings
         */

        $this->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Qoxag_Layout::get_type(),
            [
                'name' => 'layout',
            ]
        );

        $this->end_controls_section();

        
        $this->start_controls_section(
            'featured_section',
            [
                'label' => esc_html__('Featured', 'qoxag'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_group_control(
            Qoxag_Layout::get_type(),
            [
                'name' => 'featured'
            ]
        );

        $this->end_controls_section();
        
        /*
         * Advanced Ordering Settings
         */
        $this->advance_ordering_controls();


        /*
         * Title Style
         */
        $this->title_style_controls();

        /*
         * Image Style
         */
        $this->image_style_controls();


        /*
         * Meta and Category Style
         */
        $this->meta_style_controls();

        /*
         * Content Style
         */
        $this->description_style_controls();

        /*
         * Advanced style Style
         */
        $this->start_controls_section(
            'section_wrapper_style', [
                'label' => esc_html__('Wrapper Style', 'qoxag'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_width',
            [
                'label' => esc_html__('Content Width', 'qoxag'),
                'type' => Controls_Manager::SLIDER,
                'condition' => ['layout_layout_style' => ['thumb-left', 'thumb-right']],
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 12,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 2,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-post-grid .qoxag-grid-single.thumb-left .post-content' => 'flex-grow: {{SIZE}};',
                    '{{WRAPPER}} .qoxag-post-grid .qoxag-grid-single.thumb-right .post-content' => 'flex-grow: {{SIZE}};',
                ],
            ]
        );

        $this->advanced_style_controls();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $tpl = get_widget_template($this->get_name());
        include $tpl;
    }

    protected function content_template()
    {
    }
}